//Motion blur pixel shader - used to blur the scene in the direction of camera movement

Texture2D texture0 : register(t0);
SamplerState sampler0 : register(s0);

cbuffer BlurBuffer : register(b0)
{
	float2 direction;	//Direction of the blur
	float2 screenDimensions;	//Dimensions of the screen for texel calculations
}

struct InputType
{
	float4 position : SV_POSITION;
	float2 tex : TEXCOORD0;
	float3 normal : NORMAL;
};

float4 main(InputType input) : SV_TARGET
{
	//Preset weights of the blur
	float weight0 = 0.4f;
	float weight1 = 0.2f;
	float weight2 = 0.15f;
	float weight3 = 0.1f;
	float weight4 = 0.05f;
	float weight5 = 0.045f;
	float weight6 = 0.0425f;
	float weight7 = 0.0420f;
	float weight8 = 0.0410f;
	float weight9 = 0.0405f;

	float4 colour = float4(0.0f, 0.0f, 0.0f, 0.0f);	//Initialize the colour to be totally black with no alpha

	float2 texelSize = 1.0f / screenDimensions;	//Calculate texel size

	//Apply a blur based on the direction and weights, increasing the position
	colour += texture0.Sample(sampler0, input.tex) * weight0;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 1.0f) *  weight1;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 2.0f) *  weight2;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 3.0f) *  weight3;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 4.0f) *  weight4;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 5.0f) *  weight5;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 6.0f) *  weight6;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 7.0f) *  weight7;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 8.0f) *  weight8;
	colour += texture0.Sample(sampler0, input.tex + texelSize * direction * 9.0f) *  weight9;

	colour.a = 1.0f;	//The colour should be fully opaque

	return colour;
}